unit WinForm;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data, System.Resources, System.IO, System.Drawing.Printing;

type
  TWinForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    OpenFileDialog1: System.Windows.Forms.OpenFileDialog;
    Button1: System.Windows.Forms.Button;
    RichTextBox1: System.Windows.Forms.RichTextBox;
    Button2: System.Windows.Forms.Button;
    Button3: System.Windows.Forms.Button;
    Button4: System.Windows.Forms.Button;
    SaveFileDialog1: System.Windows.Forms.SaveFileDialog;
    Button5: System.Windows.Forms.Button;
    FontDialog1: System.Windows.Forms.FontDialog;
    Button6: System.Windows.Forms.Button;
    ComboBox1: System.Windows.Forms.ComboBox;
    Button7: System.Windows.Forms.Button;
    TextBox1: System.Windows.Forms.TextBox;
    CheckBox1: System.Windows.Forms.CheckBox;
    CheckBox2: System.Windows.Forms.CheckBox;
    CheckBox3: System.Windows.Forms.CheckBox;
    NumericUpDown1: System.Windows.Forms.NumericUpDown;
    Button8: System.Windows.Forms.Button;
    PrintDialog1: System.Windows.Forms.PrintDialog;
    PrintPreviewDialog1: System.Windows.Forms.PrintPreviewDialog;
    PageSetupDialog1: System.Windows.Forms.PageSetupDialog;
    Button9: System.Windows.Forms.Button;
    PrintDocument1: System.Drawing.Printing.PrintDocument;
    Button10: System.Windows.Forms.Button;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure Button1_Click(sender: System.Object; e: System.EventArgs);
    procedure Button2_Click(sender: System.Object; e: System.EventArgs);
    procedure Button3_Click(sender: System.Object; e: System.EventArgs);
    procedure Button6_Click(sender: System.Object; e: System.EventArgs);
    procedure RichTextBox1_TextChanged(sender: System.Object; e: System.EventArgs);
    procedure Button4_Click(sender: System.Object; e: System.EventArgs);
    procedure ComboBox1_SelectedIndexChanged(sender: System.Object; e: System.EventArgs);
    procedure TWinForm_Load(sender: System.Object; e: System.EventArgs);
    procedure Button7_Click(sender: System.Object; e: System.EventArgs);
    procedure CheckBox1_CheckedChanged(sender: System.Object; e: System.EventArgs);
    procedure CheckBox2_CheckedChanged(sender: System.Object; e: System.EventArgs);
    procedure CheckBox3_CheckedChanged(sender: System.Object; e: System.EventArgs);
    procedure NumericUpDown1_ValueChanged(sender: System.Object; e: System.EventArgs);
    procedure TWinForm_Closing(sender: System.Object; e: System.ComponentModel.CancelEventArgs);
    procedure Button8_Click(sender: System.Object; e: System.EventArgs);
    procedure PrintPreviewDialog1_Load(sender: System.Object; e: System.EventArgs);
    procedure Button9_Click(sender: System.Object; e: System.EventArgs);
    procedure PrintDocument1_PrintPage(sender: System.Object; e: System.Drawing.Printing.PrintPageEventArgs);
    procedure Button10_Click(sender: System.Object; e: System.EventArgs);

  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  private
  NazwaPliku: String;
  modyfikacja: boolean;

  procedure ZmienCzcionke;
    { Private Declarations }
  public
    constructor Create;
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(TWinForm))]

implementation

{$AUTOBOX ON}

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWinForm.InitializeComponent;
type
  TArrayOfInteger = array of Integer;
var
  resources: System.Resources.ResourceManager;
begin
  resources := System.Resources.ResourceManager.Create(TypeOf(TWinForm));
  Self.OpenFileDialog1 := System.Windows.Forms.OpenFileDialog.Create;
  Self.Button1 := System.Windows.Forms.Button.Create;
  Self.RichTextBox1 := System.Windows.Forms.RichTextBox.Create;
  Self.Button2 := System.Windows.Forms.Button.Create;
  Self.Button3 := System.Windows.Forms.Button.Create;
  Self.Button4 := System.Windows.Forms.Button.Create;
  Self.SaveFileDialog1 := System.Windows.Forms.SaveFileDialog.Create;
  Self.Button5 := System.Windows.Forms.Button.Create;
  Self.FontDialog1 := System.Windows.Forms.FontDialog.Create;
  Self.Button6 := System.Windows.Forms.Button.Create;
  Self.ComboBox1 := System.Windows.Forms.ComboBox.Create;
  Self.Button7 := System.Windows.Forms.Button.Create;
  Self.TextBox1 := System.Windows.Forms.TextBox.Create;
  Self.CheckBox1 := System.Windows.Forms.CheckBox.Create;
  Self.CheckBox2 := System.Windows.Forms.CheckBox.Create;
  Self.CheckBox3 := System.Windows.Forms.CheckBox.Create;
  Self.NumericUpDown1 := System.Windows.Forms.NumericUpDown.Create;
  Self.Button8 := System.Windows.Forms.Button.Create;
  Self.PrintDialog1 := System.Windows.Forms.PrintDialog.Create;
  Self.PrintPreviewDialog1 := System.Windows.Forms.PrintPreviewDialog.Create;
  Self.PageSetupDialog1 := System.Windows.Forms.PageSetupDialog.Create;
  Self.PrintDocument1 := System.Drawing.Printing.PrintDocument.Create;
  Self.Button9 := System.Windows.Forms.Button.Create;
  Self.Button10 := System.Windows.Forms.Button.Create;
  (System.ComponentModel.ISupportInitialize(Self.NumericUpDown1)).BeginInit;
  Self.SuspendLayout;
  // 
  // OpenFileDialog1
  // 
  Self.OpenFileDialog1.DefaultExt := 'txt';
  Self.OpenFileDialog1.Filter := 'Plik tekstowy | *.txt| Wszystkie pliki|*.*';
  Self.OpenFileDialog1.FilterIndex := 2;
  Self.OpenFileDialog1.Title := 'Wybiez plik ...';
  // 
  // Button1
  // 
  Self.Button1.Location := System.Drawing.Point.Create(10, 46);
  Self.Button1.Name := 'Button1';
  Self.Button1.Size := System.Drawing.Size.Create(90, 27);
  Self.Button1.TabIndex := 1;
  Self.Button1.Text := 'Otwrz';
  Include(Self.Button1.Click, Self.Button1_Click);
  // 
  // RichTextBox1
  // 
  Self.RichTextBox1.BorderStyle := System.Windows.Forms.BorderStyle.FixedSingle;
  Self.RichTextBox1.HideSelection := False;
  Self.RichTextBox1.Location := System.Drawing.Point.Create(106, 46);
  Self.RichTextBox1.Name := 'RichTextBox1';
  Self.RichTextBox1.Size := System.Drawing.Size.Create(643, 434);
  Self.RichTextBox1.TabIndex := 2;
  Self.RichTextBox1.Text := '';
  Include(Self.RichTextBox1.TextChanged, Self.RichTextBox1_TextChanged);
  // 
  // Button2
  // 
  Self.Button2.Location := System.Drawing.Point.Create(10, 74);
  Self.Button2.Name := 'Button2';
  Self.Button2.Size := System.Drawing.Size.Create(90, 26);
  Self.Button2.TabIndex := 3;
  Self.Button2.Text := 'Zapisz';
  Include(Self.Button2.Click, Self.Button2_Click);
  // 
  // Button3
  // 
  Self.Button3.Location := System.Drawing.Point.Create(10, 102);
  Self.Button3.Name := 'Button3';
  Self.Button3.Size := System.Drawing.Size.Create(90, 26);
  Self.Button3.TabIndex := 4;
  Self.Button3.Text := 'Zapisz jako';
  Include(Self.Button3.Click, Self.Button3_Click);
  // 
  // Button4
  // 
  Self.Button4.Location := System.Drawing.Point.Create(10, 129);
  Self.Button4.Name := 'Button4';
  Self.Button4.Size := System.Drawing.Size.Create(90, 27);
  Self.Button4.TabIndex := 5;
  Self.Button4.Text := 'Zapisz kopi';
  Include(Self.Button4.Click, Self.Button4_Click);
  // 
  // Button5
  // 
  Self.Button5.Location := System.Drawing.Point.Create(10, 157);
  Self.Button5.Name := 'Button5';
  Self.Button5.Size := System.Drawing.Size.Create(90, 26);
  Self.Button5.TabIndex := 6;
  Self.Button5.Text := 'Znajd';
  // 
  // FontDialog1
  // 
  Self.FontDialog1.ShowColor := True;
  // 
  // Button6
  // 
  Self.Button6.Location := System.Drawing.Point.Create(10, 185);
  Self.Button6.Name := 'Button6';
  Self.Button6.Size := System.Drawing.Size.Create(90, 26);
  Self.Button6.TabIndex := 7;
  Self.Button6.Text := 'Czcionka';
  Include(Self.Button6.Click, Self.Button6_Click);
  // 
  // ComboBox1
  // 
  Self.ComboBox1.Location := System.Drawing.Point.Create(106, 18);
  Self.ComboBox1.Name := 'ComboBox1';
  Self.ComboBox1.Size := System.Drawing.Size.Create(182, 24);
  Self.ComboBox1.TabIndex := 8;
  Self.ComboBox1.Text := 'ComboBox1';
  Include(Self.ComboBox1.SelectedIndexChanged, Self.ComboBox1_SelectedIndexChanged);
  // 
  // Button7
  // 
  Self.Button7.Location := System.Drawing.Point.Create(240, 489);
  Self.Button7.Name := 'Button7';
  Self.Button7.Size := System.Drawing.Size.Create(90, 27);
  Self.Button7.TabIndex := 9;
  Self.Button7.Text := 'Szukaj';
  Include(Self.Button7.Click, Self.Button7_Click);
  // 
  // TextBox1
  // 
  Self.TextBox1.Location := System.Drawing.Point.Create(106, 489);
  Self.TextBox1.Name := 'TextBox1';
  Self.TextBox1.Size := System.Drawing.Size.Create(120, 22);
  Self.TextBox1.TabIndex := 10;
  Self.TextBox1.Text := '';
  // 
  // CheckBox1
  // 
  Self.CheckBox1.Location := System.Drawing.Point.Create(374, 18);
  Self.CheckBox1.Name := 'CheckBox1';
  Self.CheckBox1.Size := System.Drawing.Size.Create(125, 28);
  Self.CheckBox1.TabIndex := 12;
  Self.CheckBox1.Text := 'Pogrubiona';
  Include(Self.CheckBox1.CheckedChanged, Self.CheckBox1_CheckedChanged);
  // 
  // CheckBox2
  // 
  Self.CheckBox2.Location := System.Drawing.Point.Create(499, 18);
  Self.CheckBox2.Name := 'CheckBox2';
  Self.CheckBox2.Size := System.Drawing.Size.Create(125, 28);
  Self.CheckBox2.TabIndex := 13;
  Self.CheckBox2.Text := 'Pochylona';
  Include(Self.CheckBox2.CheckedChanged, Self.CheckBox2_CheckedChanged);
  // 
  // CheckBox3
  // 
  Self.CheckBox3.Location := System.Drawing.Point.Create(624, 18);
  Self.CheckBox3.Name := 'CheckBox3';
  Self.CheckBox3.Size := System.Drawing.Size.Create(125, 28);
  Self.CheckBox3.TabIndex := 14;
  Self.CheckBox3.Text := 'Podkrelona';
  Include(Self.CheckBox3.CheckedChanged, Self.CheckBox3_CheckedChanged);
  // 
  // NumericUpDown1
  // 
  Self.NumericUpDown1.Location := System.Drawing.Point.Create(307, 18);
  Self.NumericUpDown1.Maximum := System.Decimal.Create(TArrayOfInteger.Create(45, 
          0, 0, 0));
  Self.NumericUpDown1.Minimum := System.Decimal.Create(TArrayOfInteger.Create(1, 
          0, 0, 0));
  Self.NumericUpDown1.Name := 'NumericUpDown1';
  Self.NumericUpDown1.Size := System.Drawing.Size.Create(58, 22);
  Self.NumericUpDown1.TabIndex := 15;
  Self.NumericUpDown1.Tag := '';
  Self.NumericUpDown1.Value := System.Decimal.Create(TArrayOfInteger.Create(12, 
          0, 0, 0));
  Include(Self.NumericUpDown1.ValueChanged, Self.NumericUpDown1_ValueChanged);
  // 
  // Button8
  // 
  Self.Button8.Location := System.Drawing.Point.Create(10, 212);
  Self.Button8.Name := 'Button8';
  Self.Button8.Size := System.Drawing.Size.Create(90, 27);
  Self.Button8.TabIndex := 16;
  Self.Button8.Text := 'drukuj';
  Include(Self.Button8.Click, Self.Button8_Click);
  // 
  // PrintPreviewDialog1
  // 
  Self.PrintPreviewDialog1.AutoScrollMargin := System.Drawing.Size.Create(0, 
      0);
  Self.PrintPreviewDialog1.AutoScrollMinSize := System.Drawing.Size.Create(0, 
      0);
  Self.PrintPreviewDialog1.ClientSize := System.Drawing.Size.Create(400, 300);
  Self.PrintPreviewDialog1.Enabled := True;
  Self.PrintPreviewDialog1.Icon := (System.Drawing.Icon(resources.GetObject('P' +
    'rintPreviewDialog1.Icon')));
  Self.PrintPreviewDialog1.Location := System.Drawing.Point.Create(132, 238);
  Self.PrintPreviewDialog1.MinimumSize := System.Drawing.Size.Create(375, 250);
  Self.PrintPreviewDialog1.Name := 'PrintPreviewDialog1';
  Self.PrintPreviewDialog1.TransparencyKey := System.Drawing.Color.Empty;
  Self.PrintPreviewDialog1.Visible := False;
  Include(Self.PrintPreviewDialog1.Load, Self.PrintPreviewDialog1_Load);
  // 
  // PageSetupDialog1
  // 
  Self.PageSetupDialog1.Document := Self.PrintDocument1;
  // 
  // PrintDocument1
  // 
  Include(Self.PrintDocument1.PrintPage, Self.PrintDocument1_PrintPage);
  // 
  // Button9
  // 
  Self.Button9.Location := System.Drawing.Point.Create(10, 240);
  Self.Button9.Name := 'Button9';
  Self.Button9.Size := System.Drawing.Size.Create(90, 27);
  Self.Button9.TabIndex := 17;
  Self.Button9.Text := 'Pod. wydruku';
  Include(Self.Button9.Click, Self.Button9_Click);
  // 
  // Button10
  // 
  Self.Button10.Location := System.Drawing.Point.Create(10, 268);
  Self.Button10.Name := 'Button10';
  Self.Button10.Size := System.Drawing.Size.Create(90, 26);
  Self.Button10.TabIndex := 18;
  Self.Button10.Text := 'Ust. strony';
  Include(Self.Button10.Click, Self.Button10_Click);
  // 
  // TWinForm
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(6, 15);
  Self.ClientSize := System.Drawing.Size.Create(758, 519);
  Self.Controls.Add(Self.Button10);
  Self.Controls.Add(Self.Button9);
  Self.Controls.Add(Self.Button8);
  Self.Controls.Add(Self.NumericUpDown1);
  Self.Controls.Add(Self.CheckBox3);
  Self.Controls.Add(Self.CheckBox2);
  Self.Controls.Add(Self.CheckBox1);
  Self.Controls.Add(Self.TextBox1);
  Self.Controls.Add(Self.Button7);
  Self.Controls.Add(Self.ComboBox1);
  Self.Controls.Add(Self.Button6);
  Self.Controls.Add(Self.Button5);
  Self.Controls.Add(Self.Button4);
  Self.Controls.Add(Self.Button3);
  Self.Controls.Add(Self.Button2);
  Self.Controls.Add(Self.RichTextBox1);
  Self.Controls.Add(Self.Button1);
  Self.Name := 'TWinForm';
  Self.Text := 'Edytor (Windows Forms)';
  Include(Self.Closing, Self.TWinForm_Closing);
  Include(Self.Load, Self.TWinForm_Load);
  (System.ComponentModel.ISupportInitialize(Self.NumericUpDown1)).EndInit;
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TWinForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TWinForm.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

procedure TWinForm.Button10_Click(sender: System.Object; e: System.EventArgs);
begin
  PageSetupDialog1.ShowDialog();
end;

procedure TWinForm.PrintDocument1_PrintPage(sender: System.Object; e: System.Drawing.Printing.PrintPageEventArgs);
var lpp, yPos, MarginesLewy, MarginesPrawy: Double;
  nr: integer;
  linia: String;
  sr: StringReader;
  czcionka: System.Drawing.Font;
begin
czcionka:=System.Drawing.Font.Create('Arial',36);
nr:= 0;
MarginesLewy:=e.MarginBounds.Left;
MarginesPrawy:=e.MarginBounds.Top;
linia:= '';
sr:=StringReader.Create(RichTextBox1.Text);
lpp:= e.MarginBounds.Height/czcionka.GetHeight;
linia:= sr.ReadLine;
e.HasMorePages:= true;

  while (nr < lpp) do
  begin
    if nr <> 0 then
      linia:= sr.ReadLine;
    if (linia = NIL) then
    begin
      e.HasMorePages:= false;
      break;
    end
    else
    begin
    yPos:= MarginesPrawy + (nr*czcionka.GetHeight);
     e.Graphics.DrawString (linia, czcionka, Brushes.Black, MarginesLewy, yPos, StringFormat.Create);
      inc(nr);
    end;
  end;

end;

procedure TWinForm.Button9_Click(sender: System.Object; e: System.EventArgs);
begin
  PrintPreviewDialog1.Document:=PrintDocument1;
  PrintPreviewDialog1.ShowDialog;

end;

procedure TWinForm.PrintPreviewDialog1_Load(sender: System.Object; e: System.EventArgs);
var fi: FileInfo;
begin
ComboBox1.DataSource:=System.Drawing.FontFamily.Families;
ComboBox1.DisplayMember:='Name';
if ParamCount>0 then
begin
  fi:=FileInfo.Create(ParamStr(1));
  if fi.Exists then
  begin
    NazwaPliku:=ParamStr(1);
    Text:='Edytor - '+NazwaPliku.Remove(0,NazwaPliku.LastIndexOf('\')+1);
    RichTextBox1.LoadFile(NazwaPliku);
    fi.Free;
  end
  else
  MessageBox.Show('Plik '+ParamStr(1)+' nie istnieje');
modyfikacja:=false;
end;
end;

procedure TWinForm.Button8_Click(sender: System.Object; e: System.EventArgs);
begin
  PrintDialog1.Document:=PrintDocument1;
  if printDialog1.ShowDialog=System.Windows.Forms.DialogResult.OK then
  PrintDocument1.Print;
end;

procedure TWinForm.TWinForm_Closing(sender: System.Object; e: System.ComponentModel.CancelEventArgs);
var przycisk :System.Windows.Forms.DialogResult;
begin
if modyfikacja then
  begin
  przycisk:=MessageBox.Show('Dokument zosta zmieniony. Czy zapisa zmiany?','Edytor',MessageBoxButtons.YesNoCancel);
  if  przycisk = System.Windows.Forms.DialogResult.Yes then
    if NazwaPliku<>'' then RichTextBox1.SaveFile(NazwaPliku)
    else
    begin
      Button3_Click(sender,nil);
      exit;
      end;
  if przycisk = System.Windows.Forms.DialogResult.Cancel then
  e.Cancel:=true;
  end;
end;

procedure TWinForm.NumericUpDown1_ValueChanged(sender: System.Object; e: System.EventArgs);
begin
  ZmienCzcionke;
end;

procedure TWinForm.CheckBox3_CheckedChanged(sender: System.Object; e: System.EventArgs);
begin
  ZmienCzcionke;
end;

procedure TWinForm.CheckBox2_CheckedChanged(sender: System.Object; e: System.EventArgs);
begin
  ZmienCzcionke;
end;

procedure TWinForm.CheckBox1_CheckedChanged(sender: System.Object; e: System.EventArgs);
begin
 ZmienCzcionke;
end;

procedure TWinForm.ZmienCzcionke;
var styl: FontStyle;
begin
styl:=System.Drawing.FontStyle.Regular;
if CheckBox1.Checked then styl:=System.Drawing.FontStyle.Bold;
if CheckBox2.Checked then styl:=System.Drawing.FontStyle.Italic;
if checkBox3.Checked then styl:=System.Drawing.FontStyle.Underline;
RichtextBox1.SelectionFont:=System.Drawing.Font.Create(ComboBox1.Text,System.Convert.ToInt32(NumericUpDown1.Value),styl);
RichTextBox1.Focus;
end;

procedure TWinForm.Button7_Click(sender: System.Object; e: System.EventArgs);
var pozycja,poczatek,dlugosc: integer;
    szukaj: string;
begin
szukaj:=TextBox1.Text;
with RichTextBox1 do
begin
  if SelectionLength=0 then
  begin
    poczatek:=SelectionStart;
    dlugosc:=Text.Length;
  end
  else
  begin
    poczatek:=SelectionStart+SelectionLength;
    dlugosc:=Text.Length;
  end;
  pozycja:=Find(szukaj,poczatek,dlugosc,RichTextBoxFinds.WholeWord);
  if pozycja>=0 then
  Select(pozycja,szukaj.Length);
end;

end;

procedure TWinForm.TWinForm_Load(sender: System.Object; e: System.EventArgs);
var fi: FileInfo;
begin
ComboBox1.DataSource:=System.Drawing.FontFamily.Families;
ComboBox1.DisplayMember:='Name';
modyfikacja:=false;
if ParamCount>0 then
begin
  fi:=FileInfo.Create(ParamStr(1));
  if fi.Exists then
  begin
    NazwaPliku:=ParamStr(1);
    Text:='Edytor - '+NazwaPliku.Remove(0,NazwaPliku.LastIndexOf('\')+1);
    RichTextBox1.LoadFile(NazwaPliku);
    fi.Free;
  end
  else
  modyfikacja:=false;
  MessageBox.Show('Plik '+ParamStr(1)+' nie istnieje');
end;

end;

procedure TWinForm.ComboBox1_SelectedIndexChanged(sender: System.Object; e: System.EventArgs);
begin
ZmienCzcionke;
end;

procedure TWinForm.Button4_Click(sender: System.Object; e: System.EventArgs);
begin
SaveFileDialog1.FileName:=NazwaPliku;
  if SaveFileDialog1.ShowDialog=System.Windows.Forms.DialogResult.OK then
  begin
    RichTextBox1.SaveFile(NazwaPliku);
  end;
end;

procedure TWinForm.RichTextBox1_TextChanged(sender: System.Object; e: System.EventArgs);
begin
  if not modyfikacja then Text:='Edytor - '+Text+' (Zmodyfikowany)';
  modyfikacja:=true;
end;

procedure TWinForm.Button6_Click(sender: System.Object; e: System.EventArgs);
begin
if RichTextBox1.SelectionLength=0 then MessageBox.Show('Nie zaznaczye tekstu!')  //Jeli nie zaznaczono adnego fragmentu
else
if FontDialog1.ShowDialog=System.Windows.Forms.DialogResult.OK then
begin
  RichTextBox1.SelectionFont:=FontDialog1.Font;
  RichTextBox1.SelectionColor:=FontDialog1.Color;
end;
end;

procedure TWinForm.Button3_Click(sender: System.Object; e: System.EventArgs);
begin
  SaveFileDialog1.FileName:=NazwaPliku;
  if SaveFileDialog1.ShowDialog=System.Windows.Forms.DialogResult.OK then
  begin
    NazwaPliku:=SaveFileDialog1.FileName;
    RichTextBox1.SaveFile(NazwaPliku);
    Text:='Edytor - '+NazwaPliku.Remove(0,NazwaPliku.LastIndexOf('\')+1);
    modyfikacja:=false;
  end;
end;

procedure TWinForm.Button2_Click(sender: System.Object; e: System.EventArgs);
begin
  RichTextBox1.SaveFile(NazwaPliku);
  Text:='Edytor - '+NazwaPliku.Remove(0,NazwaPliku.LastIndexOf('\')+1);
  modyfikacja:=false;
end;

procedure TWinForm.Button1_Click(sender: System.Object; e: System.EventArgs);
var v: FileInfo;
begin
OpenFileDialog1.FileName:=NazwaPliku;
if OpenFileDialog1.ShowDialog=System.Windows.Forms.DialogResult.OK then
begin
  NazwaPliku:=OpenFileDialog1.FileName;
  v:=FileInfo.Create(NazwaPliku);
  if v.Extension='.rtf' then RichTextBox1.LoadFile(NazwaPliku)
  else
    RichTextBox1.LoadFile(NazwaPliku,RichTextBoxStreamType.PlainText);

  Text:='Edytor - '+v.get_Name;
  modyfikacja:=false;
end;
end;

end.
